﻿namespace Hims.Api.Models.DentalEncounter
{
    using System.Collections.Generic;
    using Hims.Api.Models.InternalMedicine;
    using Hims.Shared.Library.Enums;

    /// <summary>
    /// The dental encounter images.
    /// </summary>
    public class DentalEncounterImages
    {
        /// <summary>
        /// Gets or sets the images.
        /// </summary>
        public List<SkinTypes> Images { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public DentalEncounterType Type { get; set; }
    }
}
